/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
struct Struct // custom structure
{
   Flt  f;
   Int  i;
   Byte b;
}data[10]= // sample data array
{
   {1.0, 15, 4},
   {2.0, 25, 3},
   {3.0, 35, 2},
   {4.0, 45, 1},
};
ListGroup lstg[]= // gui list group (stores information about structure format)
{
   ListGroupS(DATA_REAL,Struct,f,0.3,"Float"  ), // group describing 'f' member in 'Struct' structure, width of group=0.3, name="Float"
   ListGroupS(DATA_INT ,Struct,i,0.3,"Integer"), // group describing 'i' member in 'Struct' structure, width of group=0.3, name="Integer"
   ListGroupS(DATA_INT ,Struct,b,0.2,"Byte"   ), // group describing 'b' member in 'Struct' structure, width of group=0.2, name="Byte"
};
/******************************************************************************/
Window       window; // gui window
Region       region; // gui region
List<Struct> list  ; // gui list
/******************************************************************************/
void InitPre()
{
   App.name="List";
   App.flag=APP_NO_FX;
   PakAdd("../data/engine.pak");
   D.mode(800,600);
}
/******************************************************************************/
Bool Init()
{
   Text_ds.color =BLACK;
   Text_ds.shadow=0;

   Gui   +=window.create(Rect(-0.5,-0.4,0.5,0.4),"Window with list");
   window+=region.create(Rect(0.05,-0.6,0.95,-0.1));                // create region
   region+=list  .create(lstg,ELMS(lstg)).setData(data,ELMS(data)); // create list with 'lstg' groups and 'data' data

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   Gui.update();
   return true;
}
/******************************************************************************/
void Draw()
{
   D  .clear(WHITE);
   Gui.draw ();
   if(Struct *cur=list())D.text(0,-0.7,S+"current element's Integer value "+cur->i);
                         D.text(0,-0.8,S+"current element (on the list) "  +list.cur);
                         D.text(0,-0.9,S+"original element (in data) "     +list.orderToElm(list.cur));
}
/******************************************************************************/
